<?php

/**

 *

 * Template Name: Plan du site

 * This is the template that displays all pages by default.

 * Please note that this is the WordPress construct of pages

 * and that other 'pages' on your WordPress site will use a

 * different template.

 *

 * @package WordPress

 * @subpackage Twenty_Ten

 * @since Twenty Ten 1.0

 */



get_header(); ?>





<div class="span8 offset2">

	

	<div id="container">

		<div id="content" role="main">



			<?php

			/* Run the loop to output the page.

			 * If you want to overload this in a child theme then include a file

			* called loop-page.php and that will be used instead.

			*/

			get_template_part( 'loop', 'page' );

			?>



			<?php 

			echo '<div id="sitemap" >';

			echo displaySiteMap(null, $menu_items, $currentId, 1);

			echo '</div>';



			/*

			 * dfr, 10.2012

			* display recursively the site map :

			*/

			function displaySiteMap($root, $menu, $currentId, $depth) {

				global $menuPosition;

				if($depth > 3) {

					return "";

				}

				$hasSubmenu = false;

				$display_menu = '<div class="sitemap_depth_' . $depth . '">'. "\n";

				$depth++;

				foreach ( (array) $menu as $key => $menu_item ) {

					if(($menu_item->menu_item_parent == 0 && is_null($root))

							|| $menu_item->menu_item_parent == $root->ID) {

						$hasSubmenu = true;
$htmlId = "";
						if($depth == 2) {
							$htmlId = ' id="sitemap_'. preg_replace("/[^A-Za-z0-9]/", '', $menu_item->title) .'" ';
						}

						if($menu_item->url == "") {

$display_menu .= '<div class="sitemap_item"><a' . $htmlId . '>' . $menu_item->title . '</a>';

						} else {

$display_menu .= '<div class="sitemap_item"><a' . $htmlId . ' href="' . $menu_item->url . '">' . $menu_item->title . '</a>';

						}

						$display_menu .= displaySiteMap($menu_item, $menu, $currentId, $depth);

						$display_menu .=  "</div>\n";

					}

				}

				$display_menu .=	 '</div>'. "\n";

				if($hasSubmenu){

					return $display_menu;

				} else {

					return "";

				}

			}

			?>

		</div>

		<!-- #content -->

	</div>

	<!-- #container -->

</div>

<div class="sidebarRight span2">

<!-- Custom Field Nouveautés -->
		<?php if(get_field('nouveautes')):?>
		
		<div>
			<h4>NOUVEAUTES</h4>
			<ul>
			<?php while( has_sub_field("nouveautes")): ?>
				<li><a href="<?php the_sub_field('url'); ?>" 
					<?php
							if(get_sub_field('nouvelle_fenetre')) {
								echo 'target="_blank"';
							} else {
								echo 'target=""';
							}
							?>
					><?php the_sub_field('nom'); ?></a></li>
			<?php endwhile; ?>	
			</ul>
			
        </div>
		<?php endif; ?>
<!-- End Custom Field Nouveautés -->


<!-- Custom Field Info Texte -->	
	        <?php if(get_field('Texte')):?>
	        <div>
				<!-- <h4>INFO TEXTE</h4> -->
				<?php while( has_sub_field("Texte")): ?>
					<p><b><?php the_sub_field('titre');?></b></p>
					<p>
						<?php the_sub_field('texte');?>
					<!-- <br> -->
					<a href="<?php the_sub_field('url');?>" 
						<?php
							if(get_sub_field('nouvelle_fenetre')) {
								echo 'target="_blank"';
							} else {
								echo 'target=""';
							}
							?> ><?php the_sub_field('lien');?></a>
					</p>
	        	<?php endwhile; ?> 
	        </div>
			<?php endif; ?>
<!-- End Custom Field Info Texte -->


<!-- Custom Field Images -->	
			<?php// if(get_field('info_image_image') || get_field('info_image_caption')):?>
	        <?php if(get_field('Images')):?>
	        <div>
				<!-- <h4>INFO IMAGE</h4> -->
				
					<?php while( has_sub_field("Images")): ?>
					<div>
						<a href="<?php the_sub_field('url'); ?>"
							<?php
							if(get_sub_field('nouvelle_fenetre')) {
								echo 'target="_blank"';
							} else {
								echo 'target=""';
							}
							?>
							>
						<img src="<?php the_sub_field('image');?>" /></a> 
					</div>
					<p><?php the_sub_field('legende');?></p>
	        		
	        		<?php endwhile; ?>
	        </div>
			<?php endif; ?>


<!-- End Custom Images -->	
<!-- Custom Field Video -->	
			<?php if(get_field('video')):?>
	        <div>
				<h4>VIDEO</h4>
				<ul>
					<li class="divider"></li>
					<?php while( has_sub_field("video") ): ?>
					<li>
						<iframe width="160" height="120" src="<?php the_sub_field('url'); ?>" frameborder="0" allowfullscreen></iframe>
						<p><?php the_sub_field('legende');?></p>
					</li>
					
					<?php endwhile; ?>
				</ul>        
	        </div>
			<?php endif; ?>
<!-- End Custom Video -->
<!-- Custom Field Autres Liens -->			
			<?php if(get_field('autres_liens')):?>
	        <div>
				<h4>AUTRES LIENS</h4>
				<ul>
					<?php while( has_sub_field("autres_liens") ): ?>
						<li class="divider"></li>
						<li>
							<a href="<?php the_sub_field('url'); ?>"
							<?php
							if(get_sub_field('nouvelle_fenetre')) {
								echo 'target="_blank"';
							} else {
								echo 'target=""';
							}
							?>
							><img src="<?php echo get_option('siteurl'); ?>/wp-content/themes/BCUL/assets/images/icon-link.png" alt="link" /><?php the_sub_field('nom'); ?></a>
						</li>
					 	
					<?php endwhile; ?>
				</ul>        
	        </div>
			<?php endif; ?>      
<!-- End Custom Field Autres Liens -->   

	</div>

<?php get_footer(); ?>