<?php
/**
 * 
 * Template Name: Newsletter - confirmation
 * ..../newsletter-desinscription/?nlid=XXX&nlm=YYYY@YY.YY
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Twenty_Ten
 * @since Twenty Ten 1.0
 */

get_header(); ?>

<div class="span3">&nbsp;</div>

<div class="span7">
	<div class="ml15">
	<?php
	
	    /*** DEBUG "TOOLS" ***/
	    $debugMode = false; //set it to true if you want to debug
	    
		$newsletterId = 0;
		$email = '';
		
		$clientErrorStr = "<p>Une erreur s'est produite lors de la désinscription. Veuillez remplir à nouveau le formulaire d'inscription.</p> ".
					  	  "<p>Si le problème se répète, merci de nous contacter via ce formulaire : ".
					  	  "<a href=\"http://bcultest1.cdi.ch/feedback\">Feedback</a></p>";	
					  
		if (isset($_POST['unsubscribe']) && (int)$_POST['nlid']>0 && $_POST['nlm']!='')
		{
			$newsletterId = (int)$_POST['nlid'];
			$email 		  = $_POST['nlm'];
			
			/*** Create soapclient ***/
			try 
			{
				$client = new SoapClient("http://newsletter.cdi.ch/services/services/CdiNewsletterService.svc?Wsdl", 
										 array('cache_wsdl' => 0, 'trace' => 1));
			    if($debugMode)
				{
				    echo "<br/><br/><b>Soap client types:</b><br/>";
					var_dump($client->__getTypes());
				    echo "<br/><br/><b>Soap client functions:</b><br/>";
			   		var_dump($client->__getFunctions());
				}
			}
			catch (Exception $e) 
			{
				echo $clientErrorStr;
			    echo '<br/><b>Erreur :</b>',  $e->getMessage(), "\n";
			}
			
			/*** do unsubsribe ***/
			try
			{
				$unsubscribeRequest = array('ClientGuid'   => 'd973a6e3-acd8-4ae3-8879-19c3f5c2315e',
						     	            'Password' 	   => 'g^GwOr=W$KpOTXAr',
					 	      		        'Email'        => $email,
										    'NewsletterId' => $newsletterId);
				$unsubscribeResponse = $client->Unsubscribe(array('request' => $unsubscribeRequest));
				if($debugMode)
				{
			    	echo "<br/><br/><b>Unsubscribe response:</b><br/>";
					var_dump($unsubscribeResponse);
				}
				if($unsubscribeResponse->UnsubscribeResult->Result==true)
					echo "<p>Votre désinscription à la newsletter de la BCUL a été enregistrée pour $email.<p/>";
				else 
				{
					echo $clientErrorStr;
					
					if($unsubscribeResponse->UnsubscribeResult->ErrorMessage!='')
					{
						echo "<br/> <br/> <i>Erreur (".$unsubscribeResponse->UnsubscribeResult->ErrorCode.") : ".
					 	$unsubscribeResponse->UnsubscribeResult->ErrorMessage."</i>";
					}
				}
			}
			catch (SoapFault $fault)
			{
				echo $clientErrorStr;
				if($debugMode)
				{
					echo "<br/><b>Fault code:</b> {$fault->faultcode}" . "<br/>";
				 	echo "<br/><b>Fault string:</b> {$fault->faultstring}" . "<br/><br/><br/>";
				    echo "<br/><p>Request :".htmlspecialchars($client->__getLastRequest()) ."</p>";
				    echo "<br/><p>Response :".htmlspecialchars($client->__getLastResponse())."</p>";
				}
			 	if ($client != null)
			 	{
			 		$client = null;
			 	}
			 	exit();
			}
		}
		elseif((int)$_GET['nlid']>0 || $_GET['nlm']!='')
		{
			echo "<p>Email à désinscrire: ".$_GET['nlm']."</p>";
		}
		else 
		{
			echo $clientErrorStr;
		}
	?>
	<form action="<?php the_permalink(); ?>" method="post" 
		<?php if (((int)$_GET['nlid']<=0 || $_GET['nlm']=='') || isset($_POST['unsubscribe']))  { echo ' style="display: none"'; } ?> 
		onsubmit="return confirm('Êtes-vous sûr de vouloir vous désinscrire de la newsletter de la BCUL ?');">
		<input type="hidden" name="nlid" value="<?php echo $_GET['nlid']; ?>">
		<input type="hidden" name="nlm" value="<?php echo $_GET['nlm']; ?>">
		<input type="submit" name="unsubscribe" value="Se désinscrire de la newsletter"/>
	</form>
	</div>
</div>
<div class="sidebarRight span2">&nbsp;</div>

<?php get_footer(); ?>