<?php
/**
 * 
 * Template Name: Newsletter - bloc
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Twenty_Ten
 * @since Twenty Ten 1.0
 */

get_header(); ?>

<div class="span3">&nbsp;</div>

<div class="span7">
	<!-- <div class="ml15"> -->
<?php

    /*** DEBUG "TOOLS" ***/
    $debugMode = false; //set it to true if you want to debug
    
	$newsletterId = 0;
	$blockId = '';
	$lang = 'fr';
	
	$clientErrorStr = "Une erreur s'est produite lors l'ouverture du bloc de détail de la Newsletter.<br/> ".
				  	  "Si le problème se répète, merci de nous contacter via ce formulaire : ".
				  	  "<a href=\"http://bcultest1.cdi.ch/feedback\">Feedback</a>";	

	if(((int)$_GET['nlid'])<=0 || ((int)$_GET['nlbid'])<=0 || $_GET['nllang']=='')
	{
		echo $clientErrorStr;	
	}
	else 
	{
		$newsletterId = (int)$_GET['nlid'];
		$blockId 	  = (int)$_GET['nlbid'];
		$lang 		  = $_GET['nllang'];
		
		/*** Create soapclient ***/
		try 
		{
			$client = new SoapClient("http://newsletter.cdi.ch/services/services/CdiNewsletterService.svc?Wsdl", 
									 array('cache_wsdl' => 0, 'trace' => 1));
		    if($debugMode)
			{
			    echo "<br/><br/><b>Soap client types:</b><br/>";
				var_dump($client->__getTypes());
			    echo "<br/><br/><b>Soap client functions:</b><br/>";
		   		var_dump($client->__getFunctions());
			}
		}
		catch (Exception $e) 
		{
			echo $clientErrorStr;
		    echo '<br/><b>Erreur :</b>',  $e->getMessage(), "\n";
		}

		/*** Show Newsletter block ***/
		try
		{
			$GetNewsletterBlockDetailRequest = array('ClientGuid' 	 	 => 'd973a6e3-acd8-4ae3-8879-19c3f5c2315e',
					     	      		      		 'Password' 	 	 => 'g^GwOr=W$KpOTXAr',
						 	      		      	     'Language' 	 	 => $lang,
													 'IncludeFooter' 	 => false,
													 'Language' 	 	 => $lang,
													 'NewsletterBlockId' => $blockId,
													 'NewsletterId' 	 => $newsletterId);
						 
		 	$response = $client->GetNewsletterBlockDetail(array('request' => $GetNewsletterBlockDetailRequest));
			if($debugMode)
				var_dump($response);
			if($response->GetNewsletterBlockDetailResult->Status=="Success")
			{
				echo $response->GetNewsletterBlockDetailResult->Result;
				
				echo "<p style=\"max-width:550px; text-align:right;font-weight:bold;\"><a href=\"".get_site_url()."/newsletter/?nlid=$newsletterId&nllang=$lang\">Revenir à la newsletter</a></p>";
			}
			else 
			{
				echo "Impossible d'afficher le détail du bloc de la Newsletter";
				
				if($response->GetNewsletterBlockDetailResult->ErrorMessage!='')
				{
					echo "<br/> <br/> <i>Erreur (".$response->GetNewsletterBlockDetailResult->ErrorCode.") : ".
					$response->GetNewsletterBlockDetailResult->ErrorMessage."</i>";
				}
				echo "<p><a href=\"".get_site_url()."/newsletter/?&nllang=$lang\">Revenir à la dernière newsletter.</a></p>";
			}
		}
		catch (SoapFault $fault)
		{
			echo "<b>Une erreur s'est produite !</b>";
			if($debugMode)
			{
				echo "<br/><b>Fault code:</b> {$fault->faultcode}" . "<br/>";
			 	echo "<br/><b>Fault string:</b> {$fault->faultstring}" . "<br/><br/><br/>";
			    echo "<br/><p>Request :".htmlspecialchars($client->__getLastRequest()) ."</p>";
			    echo "<br/><p>Response :".htmlspecialchars($client->__getLastResponse())."</p>";
			}
		 	if ($client != null)
		 	{
		 		$client = null;
		 	}
		 	exit();
		}
		$client = null;
		
	}
?>
	<!-- </div> -->
</div>
<div class="sidebarRight span2">&nbsp;</div>

<?php get_footer(); ?>