<?php
/**
 * 
 * Template Name: Newsletter - inscription
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Twenty_Ten
 * @since Twenty Ten 1.0
 */

    get_header(); 
    $templateUrl = get_stylesheet_directory_uri();
    wp_register_script('newsletterJS', get_template_directory_uri().'/js/page-NL.js');
    wp_enqueue_script( 'newsletterJS' );
    
    /*wp_enqueue_script('jquery-ui-datepicker');
    wp_enqueue_style('jquery-style', 'http://ajax.googleapis.com/ajax/libs/jqueryui/1.8.2/themes/smoothness/jquery-ui.css');*/
?>
<div class="span9">
    <!-- <div class="ml15"> -->
        <?php
            
            /*** DEBUG "TOOLS" ***/
            $debugMode                 = false; //set it to true if you want to debug
            $debugSubscriptionOnlyMode = false; //set it to true if you want to debug subscription only
            
            
            /*** Create soapclient ***/
            try 
            {
                $client = new SoapClient("http://newsletter.cdi.ch/services/services/CdiNewsletterService.svc?Wsdl", 
                                         array('cache_wsdl' => 0, 'trace' => 1));
                if($debugMode)
                {
                    echo "<br/><br/><b>Soap client types:</b><br/>";
                    var_dump($client->__getTypes());
                    echo "<br/><br/><b>Soap client functions:</b><br/>";
                    var_dump($client->__getFunctions());
                }
            }
            catch (Exception $e) 
            {
                echo 'Erreur : ',  $e->getMessage(), "\n";
            }
        
            /*** do inscription and confirm ***/
            $clientErrorStr = "<p class=\"confirm\">Une erreur s'est produite lors de l'inscription. Veuillez remplir à nouveau le formulaire d'inscription.<br/> ".
                              "Si le problème persiste, merci de nous contacter via ce formulaire : ".
                              "<a href=\"http://bcultest1.cdi.ch/feedback\">Feedback</a></p>";
            if($_POST['nl_name']!='' && $_POST['nl_firstname']!='' && $_POST['nl_email']!='')
            {
                
                $subscribeRequest = array('ClientGuid'  => 'd973a6e3-acd8-4ae3-8879-19c3f5c2315e',
                                          'Password'    => 'g^GwOr=W$KpOTXAr',
                                          'Email'       => $_POST['nl_email'],
                                          'FirstName'   => $_POST['nl_firstname'],
                                          'LastName'    => $_POST['nl_name'],
                                          'Language'    => 'fr',
                                          'SubscriberTypes'=> array(39,40));
                if(((int)$_POST['nl_politness'])!=100)
                    $subscribeRequest['Politness'] = (int)$_POST['nl_politness'];

                if($_POST['nl_birthdate']!='')
                    $subscribeRequest['BirthDate'] = date('c', strtotime($_POST['nl_birthdate']));

                try
                {
                    $subscribeResponse = $client->Subscribe(array('request' => $subscribeRequest));
                    if($debugMode || $debugSubscriptionMode)
                    {
                        echo "<br/><br/><b>Subscription response:</b><br/>";
                        var_dump($subscribeResponse);
                    }
                    if($subscribeResponse->SubscribeResult->Result==true)
                        echo "<p class=\"confirm\">Votre inscription à la newsletter a été enregistrée. Merci.<p/>";
                    else 
                    {
                        echo $clientErrorStr;
                        
                        if($subscribeResponse->SubscribeResult->ErrorMessage!='')
                        {
                            echo "<br/> <br/> <i>Erreur (".$subscribeResponse->SubscribeResult->ErrorCode.") : ".
                            $subscribeResponse->SubscribeResult->ErrorMessage."</i>";
                        }
                    }
                }
                catch (SoapFault $fault)
                {
                    echo $clientErrorStr;
                    if($debugMode || $debugSubscriptionMode)
                    {
                        echo "<br/><b>Fault code:</b> {$fault->faultcode}" . "<br/>";
                        echo "<br/><b>Fault string:</b> {$fault->faultstring}" . "<br/><br/><br/>";
                        echo "<br/><p>Request :".htmlspecialchars($client->__getLastRequest()) ."</p>";
                        echo "<br/><p>Response :".htmlspecialchars($client->__getLastResponse())."</p>";
                    }
                    if ($client != null)
                    {
                        $client = null;
                    }
                    exit();
                }
            }

            /*** Show Newsletter ***/
            try
            {
                $lang='fr';
                if($_GET['nllang']!='')
                    $lang = $_GET['nllang'];
                if(((int)$_GET['nlid'])<=0)
                {//get last newsletter
                    $GetLastNewsletterRequest = array('ClientGuid'    => 'd973a6e3-acd8-4ae3-8879-19c3f5c2315e',
                                                      'Password'      => 'g^GwOr=W$KpOTXAr',
                                                      'Language'      => $lang,
                                                      'IncludeFooter' => false);
                                 
                    $response = $client->GetLastNewsletter(array('request' => $GetLastNewsletterRequest));
                    if($debugMode)
                        var_dump($response);
                    if($response->GetLastNewsletterResult->Status=="Success")
                    {
                        echo $response->GetLastNewsletterResult->Result;
                    }
                    else 
                    {
                        echo "Aucune newsletter disponible pour le moment.";
                        if($response->GetLastNewsletterResult->ErrorMessage!='')
                        {
                            echo "<br/> <br/> <i>Erreur (".$response->GetLastNewsletterResult->ErrorCode.") : ".
                            $response->GetLastNewsletterResult->ErrorMessage."</i>";
                        }
                    }
                }
                else 
                {//get newsletter of a specific id
                    $GetNewsletterRequest = array('ClientGuid'    => 'd973a6e3-acd8-4ae3-8879-19c3f5c2315e',
                                                  'Password'      => 'g^GwOr=W$KpOTXAr',
                                                  'Language'      => $lang,
                                                  'IncludeFooter' => false,
                                                  'NewsletterId'  => (int)$_GET['nlid']);
                                 
                    $response = $client->GetNewsletter(array('request' => $GetNewsletterRequest));
                    if($debugMode)
                        var_dump($response);
                    if($response->GetNewsletterResult->Status=="Success")
                    {
                        echo $response->GetNewsletterResult->Result;
                    }
                    else 
                    {
                        echo "Aucune newsletter disponible pour le moment.";
                        if($response->GetNewsletterResult->ErrorMessage!='')
                        {
                            echo "<br/> <br/> <i>Erreur (".$response->GetNewsletterResult->ErrorCode.") : ".
                            $response->GetNewsletterResult->ErrorMessage."</i>";
                        }
                    }
                }
            }
            catch (SoapFault $fault)
            {
                echo "<b>Une erreur s'est produite !</b>";
                if($debugMode)
                {
                    echo "<br/><b>Fault code:</b> {$fault->faultcode}" . "<br/>";
                    echo "<br/><b>Fault string:</b> {$fault->faultstring}" . "<br/><br/><br/>";
                    echo "<br/><p>Request :".htmlspecialchars($client->__getLastRequest()) ."</p>";
                    echo "<br/><p>Response :".htmlspecialchars($client->__getLastResponse())."</p>";
                }
                if ($client != null)
                {
                    $client = null;
                }
                exit();
            }
            $client = null;
        ?>
    <!-- </div> -->
</div>
<div class="sidebarRight span3">
    <div>
        <h4>Inscription à la newsletter</h4>
        <form  name="subscribeForm" action="<?php the_permalink(); ?>" method="post" onsubmit="return validateSubscribeForm();" class="formNL">
            <label>Civilité</label>
            <SELECT name="nl_politness" >
                <OPTION VALUE="100">-- Veuillez choisir --</OPTION>
                <OPTION VALUE="0">M.</OPTION>
                <OPTION VALUE="1">Mme</OPTION>
            </SELECT>
            <label>Nom *</label>
            <input name="nl_name" type="text" required>
            <label>Prénom *</label>
            <input name="nl_firstname" type="text" required>
            <label>Email *</label>
            <input name="nl_email" type="text" required>
            <p><span><i>* champs obligatoires</i></span></p>
            <input type="submit" value="S'inscrire"/>           
        </form>
    </div>
</div>

<?php get_footer(); ?>