<?php
/**
 * Template Name: BCUL (En savoir plus)
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site will use a
 * different template.
 *
 * @package WordPress
 * @subpackage Twenty_Ten
 * @since Twenty Ten 1.0
 */

get_header(); ?>

	<div class="span3">
	<?php get_sidebar(navleft); ?>
	</div>
	<div class="span7">
		<div id="container">
			<div id="content" role="main">

			<?php
			/* Run the loop to output the page.
			 * If you want to overload this in a child theme then include a file
			 * called loop-page.php and that will be used instead.
			 */
			get_template_part( 'loop', 'page' );
			?>
			<div class="row">
				<div class="span7 ensavoirplus">
					<?php if(get_field('en_savoir_plus')):?>
					<h2>En savoir plus</h2>
					
					<ul>
						<?php while( has_sub_field("en_savoir_plus") ): ?>
						<li><a href="<?php the_sub_field('url'); ?>"
							<?php
							if(get_sub_field('nouvelle_fenetre')) {
								echo 'target="_blank"';
							} else {
								echo 'target=""';
							}
							?>
							><!-- <img src="<?php echo get_option('siteurl'); ?>/wp-content/themes/BCUL/assets/images/icon-link.png" alt="link" /> -->
							<span><?php the_sub_field('nom'); ?></span></a></li>
						
						<?php endwhile; ?>
					</ul>
					<?php endif; ?>
					
				</div>
			</div>
			</div><!-- #content -->
		</div><!-- #container -->
	</div>
	<div class="sidebarRight span2">
<!-- Custom Field Nouveautés -->
		<?php if(get_field('nouveautes')):?>
		
		<div>
			<h4>NOUVEAUTES</h4>
			<ul>
			<?php while( has_sub_field("nouveautes")): ?>
				<li><a href="<?php the_sub_field('url'); ?>" 
					<?php
							if(get_sub_field('nouvelle_fenetre')) {
								echo 'target="_blank"';
							} else {
								echo 'target=""';
							}
							?>
					><?php the_sub_field('nom'); ?></a></li>
			<?php endwhile; ?>	
			</ul>
			
        </div>
		<?php endif; ?>
<!-- End Custom Field Nouveautés -->


<!-- Custom Field Info Texte -->	
	        <?php if(get_field('Texte')):?>
	        <div>
				<!-- <h4>INFO TEXTE</h4> -->
				<?php while( has_sub_field("Texte")): ?>
					<p><b><?php the_sub_field('titre');?></b></p>
					<p>
						<div><?php the_sub_field('texte');?></div>
					<!-- <br> -->
					<div id="mailDiv"><a href="<?php the_sub_field('url');?>" 
											<?php
												if(get_sub_field('nouvelle_fenetre')) {
													echo 'target="_blank"';
												} else {
													echo 'target=""';
												}
												?> ><?php the_sub_field('lien');?></a></div>
					</p>
	        	<?php endwhile; ?> 
	        </div>
			<?php endif; ?>
<!-- End Custom Field Info Texte -->


<!-- Custom Field Images -->	
			<?php// if(get_field('info_image_image') || get_field('info_image_caption')):?>
	        <?php if(get_field('Images')):?>
	        <div>
				<!-- <h4>INFO IMAGE</h4> -->
				
					<?php while( has_sub_field("Images")): ?>
					<div>
						<a href="<?php the_sub_field('url'); ?>"
							<?php
							if(get_sub_field('nouvelle_fenetre')) {
								echo 'target="_blank"';
							} else {
								echo 'target=""';
							}
							?>
							>
						<img src="<?php the_sub_field('image');?>" /></a> 
					</div>
					<?php
						if(get_sub_field('legende')){
							echo '<p class="legende">' . get_sub_field('legende') . '</p>';
						} else {
							echo '';
						}
						?>
	        		
	        		<?php endwhile; ?>
	        </div>
			<?php endif; ?>


<!-- End Custom Images -->	
<!-- Custom Field Video -->	
			<?php if(get_field('video')):?>
	        <div>
				<h4>VIDEO</h4>
				<ul>
					<li class="divider"></li>
					<?php while( has_sub_field("video") ): ?>
					<li>
						<iframe width="160" height="120" src="<?php the_sub_field('url'); ?>" frameborder="0" allowfullscreen></iframe>
						<p><?php the_sub_field('legende');?></p>
					</li>
					
					<?php endwhile; ?>
				</ul>        
	        </div>
			<?php endif; ?>
<!-- End Custom Video -->
<!-- Custom Field Autres Liens -->			
			<?php if(get_field('autres_liens')):?>
	        <div>
				<h4>AUTRES LIENS</h4>
				<ul>
					<?php while( has_sub_field("autres_liens") ): ?>
						<li class="divider"></li>
						<li>
							<a href="<?php the_sub_field('url'); ?>"
							<?php
							if(get_sub_field('nouvelle_fenetre')) {
								echo 'target="_blank"';
							} else {
								echo 'target=""';
							}
							?>
							><!-- <img src="<?php echo get_option('siteurl'); ?>/wp-content/themes/BCUL/assets/images/icon-link.png" alt="link" /> -->
							<span><?php the_sub_field('nom'); ?></span></a>
						</li>
					 	
					<?php endwhile; ?>
				</ul>        
	        </div>
			<?php endif; ?>      
<!-- End Custom Field Autres Liens -->   

	</div>

<?php get_footer(); ?>