<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package WordPress
 * @subpackage Twenty_Ten
 * @since Twenty Ten 1.0
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta http-equiv="X-UA-Compatible" content="IE=EmulateIE9">
<meta name="viewport" content="width=device-width, user-scalable=yes">
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<title><?php
    /*
     * Print the <title> tag based on what is being viewed.
     */
    global $page, $paged;
    wp_title( '|', true, 'right' );
    // Add the blog name.
    bloginfo( 'name' );
    // Add the blog description for the home/front page.
    $site_description = get_bloginfo( 'description', 'display' );
    if ( $site_description && ( is_home() || is_front_page() ) )
        echo " | $site_description";
    // Add a page number if necessary:
    if ( $paged >= 2 || $page >= 2 )
        echo ' | ' . sprintf( __( 'Page %s', 'twentyten' ), max( $paged, $page ) );
    ?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<link rel="icon" href="<?php bloginfo('siteurl'); ?>/favicon.ico" type="image/x-icon" />
<link rel="icon" href="<?php bloginfo('siteurl'); ?>/favicon.png" type="image/png" />
<!-- style -->
<link rel="stylesheet" href="<?php echo get_option('siteurl'); ?>/wp-content/themes/BCUL/editor-style.css" type="text/css" media="screen" />
<link rel="stylesheet" href="<?php echo get_option('siteurl'); ?>/wp-content/themes/BCUL/style.css" type="text/css" media="screen" />
<link rel="stylesheet" href="<?php echo get_option('siteurl'); ?>/wp-content/themes/BCUL/assets/css/bootstrap.css" type="text/css" media="screen" />
<link rel="stylesheet" href="<?php echo get_option('siteurl'); ?>/wp-content/themes/BCUL/assets/css/bootstrap-responsive.css" type="text/css" media="screen" />
<link rel="stylesheet" href="<?php echo get_option('siteurl'); ?>/wp-content/themes/BCUL/assets/css/accordion-nav/accordion-nav.min.css?v=201902011350">
<link rel="stylesheet" href="<?php echo get_option('siteurl'); ?>/wp-content/themes/BCUL/assets/css/MobileNav.css" type="text/css" />
<!--[if IE 7]><link rel="stylesheet" href="<?php echo get_option('siteurl'); ?>/wp-content/themes/BCUL/assets/css/ie7.css"><![endif]-->
<!--[if IE 8]><link rel="stylesheet" href="<?php echo get_option('siteurl'); ?>/wp-content/themes/BCUL/assets/css/ie8.css"><![endif]-->
<!--[if IE 9]><link rel="stylesheet" href="<?php echo get_option('siteurl'); ?>/wp-content/themes/BCUL/assets/css/ie.css"><![endif]-->
<link rel="stylesheet" href="<?php echo get_option('siteurl'); ?>/wp-content/plugins/print-o-matic/css/style.css" type="text/css" media="print" />
<link rel="stylesheet" href="<?php echo get_option('siteurl'); ?>/wp-content/themes/BCUL/assets/css/bootstrap-responsive.css" type="text/css" media="print" />
<!-- JS -->
<script src="<?php echo get_option('siteurl'); ?>/wp-content/themes/BCUL/js/modernizr.js"></script>
<?php
    /* We add some JavaScript to pages with the comment form
     * to support sites with threaded comments (when in use).
     */
    if ( is_singular() && get_option( 'thread_comments' ) )
        wp_enqueue_script( 'comment-reply' );

    /* Always have wp_head() just before the closing </head>
     * tag of your theme, or you will break many plugins, which
     * generally use this hook to add elements to <head> such
     * as styles, scripts, and meta tags.
     */
    wp_head();

    /**
     * get all parent hierarchy of current page in "menu horizontal"
     */
    $menu_name = 'primary';
    $menuMobile_name = 'primary';

    //$menu = wp_get_nav_menu_object('menu horizontal' );
    $menu = wp_get_nav_menu_object('Menu principal' );
    $menuMobile = wp_get_nav_menu_object('Menu principal mobile');
    $menuFooter = wp_get_nav_menu_object('Pied de page');
    $menuSearch = wp_get_nav_menu_object('Bandeau en-tete');

    $m = new Memcached();
    $m->addServer('localhost', 11211);
        // retrieve main menu :
        if($m->get('all_menu_items')) {
            // use menu in session because menu load is very slow:
            $menu_items = $m->get('all_menu_items');
        } else {
            $menu_items = wp_get_nav_menu_items($menu->term_id);
            $main_menu_length = sizeof($menu_items);
            $position = $main_menu_length;

            for($i = 0; $i <  $main_menu_length; $i++) {
                // try to retrieve a submenu for each item in the main menu
                $sub_menu = wp_get_nav_menu_object($menu_items[$i]->title);
                if($sub_menu) {
                    $sub_menu_items = wp_get_nav_menu_items($sub_menu->term_id);
                    foreach($sub_menu_items as $subItem){
                        $subItem->menu_order = $position;
                        $position++;
                        if($subItem->menu_item_parent == 0) {
                            // link submenu roots to main menu:
                            $subItem->menu_item_parent = $menu_items[$i]->ID;
                        }
                    }
                    // add submenu to main menu:
                    $menu_items = array_merge ($menu_items, $sub_menu_items);
                }
            }
            $m->set('all_menu_items', $menu_items, 3600);
        }
        $GLOBALS['menu_items'] = $menu_items;

    if($m->get('all_menuMobile_items')) {
        // use menu in session because menu load is very slow:
        $menuMobile_items = $m->get('all_menuMobile_items');

    } else {

        $menuMobile_items = wp_get_nav_menu_items($menuMobile->term_id);
        $main_menuMobile_length = sizeof($menuMobile_items);
        $positionMobile = $main_menuMobile_length;
        for($i = 0; $i <  $main_menuMobile_length; $i++) {
            // try to retrieve a submenu for each item in the main menu
            $sub_menuMobile = wp_get_nav_menu_object($menuMobile_items[$i]->title);
            if($sub_menuMobile) {
                $sub_menuMobile_items = wp_get_nav_menu_items($sub_menuMobile->term_id);
                foreach($sub_menuMobile_items as $subItemMobile){
                    $subItemMobile->menu_order = $positionMobile;
                    $positionMobile++;
                    if($subItemMobile->menu_item_parent == 0) {
                        // link submenu roots to main menu:
                        $subItemMobile->menu_item_parent = $menuMobile_items[$i]->ID;
                    }
                }
                // add submenu to main menu:
                $menuMobile_items = array_merge ($menuMobile_items, $sub_menuMobile_items);
            }
        }
        $m->set('all_menuMobile_items', $menuMobile_items, 3600);
    }

    $GLOBALS['menuMobile_items'] = $menuMobile_items;

    //retrieve footer menu :
    if($m->get('all_menuSearch_items')) {
        // use menu in session because menu load is very slow:
        $menuFooter_items = $m->get('all_menuFooter_items');
    } else {
        $menuFooter_items = wp_get_nav_menu_items($menuFooter->term_id);
        $m->set('all_menuFooter_items', $menuFooter_items, 3600);
    }

    $GLOBALS['menuFooter_items'] = $menuFooter_items;


    $menuSearch_items = wp_get_nav_menu_items($menuSearch->term_id);

    if($m->get('all_menuSearch_items')) {
        // use menu in session because menu load is very slow:
        $menuSearch_items = $m->get('all_menuSearch_items');
    } else {
        $menuSearch_items= wp_get_nav_menu_items($menuSearch->term_id);
        $m->set('all_menuSearch_items', $menuSearch_items, 3600);
    }

    $GLOBALS['menuSearch_items'] = $menuSearch_items;

        $currentId = get_the_ID();
        $GLOBALS['currentMenuPageId'] = $currentId;

        $EM_Event = em_get_event($post->ID, 'post_id');
        $isEvent = false;
        if($EM_Event->event_id != null) {
            $categories = $EM_Event->get_categories();
            if(isset($categories->categories["1"])){
                // if it is an event page, we indicate the parent page as the current page to display the menu
                $isEvent = true;
                if(strtotime($EM_Event->event_end_date . " " . $EM_Event->event_end_time) > time()) {
                    // Page event Saison Actuelle
                    $GLOBALS['currentMenuPageId'] = 366;
                    $currentId = 366;
                } else {
                    // Page event Saison Précédente
                    $GLOBALS['currentMenuPageId'] = 878;
                    $currentId = 878;
                }
            }
        }



        $GLOBALS['parents'] = null;
        foreach( (array) $GLOBALS['menu_items'] as $key => $item){
            if($item->object_id == $currentId){
                // current element found in menu
                $GLOBALS['parents'] = getParents($item, $GLOBALS['menu_items']);
                break;
            }
        }
    $GLOBALS['parentMobiles'] = null;
    foreach( (array) $GLOBALS['menuMobile_items'] as $key => $item){
        if($item->object_id == $currentId){
            // current element found in menu
            $GLOBALS['parentMobiles'] = getParents($item, $GLOBALS['menuMobile_items']);
            break;
        }
    }


    $GLOBALS['parentsFooter'] = null;
    foreach( (array) $GLOBALS['menuFooter_items'] as $key => $item){
        if($item->object_id == $currentId){
            // current element found in menu
            $GLOBALS['parentsFooter'] = getParents($item, $GLOBALS['menuFooter_items']);
            break;
        }
    }

    $GLOBALS['parentsSearch'] = null;
    foreach( (array) $GLOBALS['menuSearch_items'] as $key => $item){
        if($item->object_id == $currentId){
            // current element found in menu
            $GLOBALS['parentsSearch'] = getParents($item, $GLOBALS['menuSearch_items']);
            break;
        }
    }
    /**
     * dfr, 9.2012
     * return a list with all parents elements of $element in $menu
     * (first element is the root page)
     */
    function getParents($element, $menu) {
        if($element->menu_item_parent == 0){
            // root element found
            return array($element);
        } else {
            $result = array();
            foreach( (array) $menu as $key => $item){
                if($item->ID == $element->menu_item_parent) {
                    // parent found, try to search its parent:
                    $result = getParents($item, $menu);
                }
            }
            // add $element at the last position of $result:
            $result[] = $element;
            return $result;
        }
    }
?>
<!-- Hotjar Tracking Code for www.bcu-lausanne.ch -->
<script>
    (function(h,o,t,j,a,r){
        h.hj=h.hj||function(){(h.hj.q=h.hj.q||[]).push(arguments)};
        h._hjSettings={hjid:1496420,hjsv:6};
        a=o.getElementsByTagName('head')[0];
        r=o.createElement('script');r.async=1;
        r.src=t+h._hjSettings.hjid+j+h._hjSettings.hjsv;
        a.appendChild(r);
    })(window,document,'https://static.hotjar.com/c/hotjar-','.js?sv=');
</script>

</head>

<body <?php body_class(); ?>>
<div id="outer-wrap">
    <div id="inner-wrap">
        <div class="container">
            <header class="row">
                <!-- bloc search -->
                <div id="blocSearch" class="span12" style="background-image:url(<?php header_image(); ?>);background-repeat:no-repeat;min-height:175px;">
                    <div class="row">
                        <!-- logo   -->
                        <div class="span2 logo">
                            <a href="<?php echo get_option('siteurl'); ?>"><img src="<?php echo get_option('siteurl'); ?>/wp-content/themes/BCUL/assets/images/logo.png" alt=""></a>
                        </div>

                        <!-- Search -->
                        <?php require("search_form.php"); ?>

                        <!-- Aide -->
                        <div class="aide">
                            <table cellspacing="0" cellpadding="0" class="span2 hidden-phone">
                                <tr class="contentBulle">
                                    <th>
                                        <div>
                                            <a href="https://renouvaud.hosted.exlibrisgroup.com/primo-explore/login?vid=41BCULIB_VU2&targetURL=https://renouvaud.hosted.exlibrisgroup.com/primo-explore/search?vid=41BCULIB_VU2" target="_blank" style="background:none">
                                            <i class="icon-user"></i>Mon compte</a>
                                        </div>
                                        <div>
                                            <a href="<?php echo get_option('siteurl'); ?>/?page_id=925">
                                            <i class="icon-envelope"></i>Contact</a>
                                        </div>
                                    </th>
                                </tr>
                                <tr>
                                    <td colspan="2"><img src="<?php echo get_option('siteurl'); ?>/wp-content/themes/BCUL/assets/images/bulleDown.png" class="pull-right" alt=""></td>
                                </tr>
                            </table>

                            <div class="visible-phone">
                                <div>
                                    <a href="#" id="loupe">
                                        <img src="<?php echo get_option('siteurl'); ?>/wp-content/themes/BCUL/assets/images/Search.png" alt="recherche" width="20" />
                                    </a>
                                </div>

                                <div>
                                    <a href="<?php echo get_option('siteurl'); ?>/?page_id=925">
                                        <img src="<?php echo get_option('siteurl'); ?>/wp-content/themes/BCUL/assets/images/contact.png" alt="compte" width="20" />
                                    </a>
                                </div>

                                <div>
                                    <a
                                    href="https://renouvaud.hosted.exlibrisgroup.com/primo-explore/login?vid=41BCULIB_VU2&targetURL=https://renouvaud.hosted.exlibrisgroup.com/primo-explore/search?vid=41BCULIB_VU2">
                                        <img src="<?php echo get_option('siteurl'); ?>/wp-content/themes/BCUL/assets/images/compte.png" alt="contact" width="20" />
                                    </a>
                                </div>
                            </div>
                        </div><!-- end Aide -->
                    </div>
                </div><!-- end bloc search-->

                <!-- Menu Principal -->
                <div id="menuH" class="span12 barnav">
                    <ul class="span12">
                        <li><?php dynamic_sidebar( 'Main menu' ); ?></li>
                        <li><?php require("menu-top.php"); ?></li>
                        <ul class="textSizer pull-right">
                        <li><a href="#">A-</a></li>
                        <li><a href="#">A+</a></li>
                    </ul>
                    </ul>
                </div><!-- end Menu Principal -->

                <!-- breadcrumbs -->
                <div class="span12">
                    <ul class="breadcrumb hidden-phone">
                        <li>
                            <?php //if ( function_exists( 'bread_crumb' ) ) bread_crumb( 'type=string' );

                            $currentId = get_the_ID();

                            if(is_search()) {
                                echo '<a href="' . $GLOBALS['menu_items'][0]->url . '">Accueil</a>';
                                echo " / <span>Recherche</span>";
                            } elseif($GLOBALS['parents'] != null) {
                                if($GLOBALS['menu_items'][0]->url == $GLOBALS['parents'][0]->url){
                                    // current page is home page
                                    echo '<span>Accueil</span>';
                                } else {
                                    echo '<a href="' . $GLOBALS['menu_items'][0]->url . '">Accueil</a>';

                                    foreach ( (array) $GLOBALS['parents'] as $key => $parent ) {
                                            if($parent->url == "" || $parent->object_id == $currentId) {
                                            // no link for current page or fake page
                                            echo " / <span>" . $parent->title . "</span>";
                                        } else {
                                            echo " / <a href='" . $parent->url . "'>" . $parent->title . "</a>";
                                        }
                                    }
                                }
                            } else {
                                echo '<a href="' . $GLOBALS['menu_items'][0]->url . '">Accueil</a>';
                                echo " / <span>" . get_the_title() . "</span>";
                            }
                            ?>
                        </li>
                    </ul>
                </div><!-- end breadcrumbs -->
            </header>

            <script type="text/javascript">
                jQuery('#loupe').click(function(){
                    jQuery('.search').css('display', 'block');
                });
            </script>

            <div id="main" class="row">
