<?php

/**
 * dfr 17.09.2013
 * Add a page in admin menu to display contact form statistics
 *
 */


/*
 * Specify Hooks/Filters
*/
add_action( 'admin_menu', 'contactstats_add_menu' );

/*
 * The Admin menu page
*/
function contactstats_add_menu(){

	// Display Settings Page link under the "Appearance" Admin Menu
	// add_theme_page( $page_title, $menu_title, $capability, $menu_slug, $function);
	$wptuts_settings_page = add_management_page(__('Statistiques contact'), __('Statistiques contact','wptuts_textdomain'), 'manage_options', 'statistics_contact_form', 'contactstats_page_fn');
}

function contactstats_get_settings() {

	$output = array();

	// put together the output array
	/*	$output['wptuts_option_name']       = ''; // the option name as used in the get_option() call.
	 $output['wptuts_page_title']        = __( 'Wptuts Settings Page','wptuts_textdomain'); // the settings page title
	$output['wptuts_page_sections']     = ''; // the setting section
	$output['wptuts_page_fields']       = ''; // the setting fields
	$output['wptuts_contextual_help']   = ''; // the contextual help
	*/
	return $output;
}

function showContactStatInlineJavascript() {
	?>
<script type="text/javascript">
  jQuery(document).ready(function() { 
	jQuery.datepicker.regional['fr'] = {
  		renderer : jQuery.ui.datepicker.defaultRenderer,
  		monthNames : [ 'Janvier', 'Février', 'Mars', 'Avril', 'Mai', 'Juin',
  			'Juillet', 'Ao�t', 'Septembre', 'Octobre', 'Novembre', 'Décembre' ],
  		monthNamesShort : [ 'Jan', 'Fév', 'Mar', 'Avr', 'Mai', 'Jun', 'Jul', 'Aoû',
  				'Sep', 'Oct', 'Nov', 'Déc' ],
  		dayNames : [ 'Dimanche', 'Lundi', 'Mardi', 'Mercredi', 'Jeudi', 'Vendredi',
  				'Samedi' ],
  		dayNamesShort : [ 'Dim', 'Lun', 'Mar', 'Mer', 'Jeu', 'Ven', 'Sam' ],
  		dayNamesMin : [ 'Di', 'Lu', 'Ma', 'Me', 'Je', 'Ve', 'Sa' ],
  		dateFormat : 'dd.mm.yy',
  		firstDay : 1,
  		prevText : '&#x3c;Pr&eacute;c',
  		prevStatus : '',
  		prevJumpText : '&#x3c;&#x3c;',
  		prevJumpStatus : '',
  		nextText : 'Suiv&#x3e;',
  		nextStatus : '',
  		nextJumpText : '&#x3e;&#x3e;',
  		nextJumpStatus : '',
  		currentText : 'Courant',
  		currentStatus : '',
  		todayText : 'Aujourd\'hui',
  		todayStatus : '',
  		clearText : '-',
  		clearStatus : '',
  		closeText : 'Fermer',
  		closeStatus : '',
  		yearStatus : '',
  		monthStatus : '',
  		weekText : 'Sm',
  		weekStatus : '',
  		dayStatus : 'DD d MM',
  		defaultStatus : '',
  		isRTL : false
  	};

  	jQuery.datepicker.setDefaults(jQuery.datepicker.regional['fr']);
     
	jQuery( "#startDate" ).datepicker({
          changeMonth: true,
          showOtherMonths: true,
          selectOtherMonths: true,
          changeYear: true,
    });
	jQuery( "#enddDate" ).datepicker({
          changeMonth: true,
          showOtherMonths: true,
          selectOtherMonths: true,
          changeYear: true,
    });
	jQuery('#enddDate').keyup(function(event) {
        if (event.keyCode == 13) { // enter pressed
            this.form.submit();
            return false;
         }
    });
    
	jQuery('#startDate').keyup(function(event) {
        if (event.keyCode == 13) {// enter pressed
            this.form.submit();
            return false;
         }
    });
    
	jQuery('#resultTable').dataTable({
	    "bJQueryUI": true,
	    "bAutoWidth": false,
	    "bStateSave": true,
        "oLanguage": {
            "sLengthMenu": "_MENU_ éléments par page",
            "sZeroRecords": "Aucun résultat",
            "sInfo": "Résultats _START_ &agrave; _END_ sur _TOTAL_",
            "sInfoEmpty": "0 résultat",
            "sInfoFiltered": "(filtr&eacute; de _MAX_ r&eacute;sultats)",
            "oPaginate": {
                "sNext": "Suivant",
                "sLast": "Dernier",
                "sPrevious": "Pr&eacute;c&eacute;dent",
                "sFirst": "Premier"
              },
              "sSearch": "Recherche"
        }
    
  });
});
  </script>
<?php 
}

function showContactStatInlineCSS() {
	?>
<style type="text/css">
.DataTables_sort_icon {
	float: left;
}

.dataTables_wrapper {
	display: inline-block;
	min-width: 500px;
}

.dataTables_filter {
	float: right;
	text-align: right;
	width: 50%;
}

.dataTables_length {
	float: left;
	width: 40%;
}

.dataTables_info {
	float: left;
	width: 60%;
}

.dataTables_paginate {
	float: right;
	text-align: right;
}
</style>
<?php 
}
/*
 * Admin Contact statistics Page HTML
*  echoes output
*/
function contactstats_page_fn() {
	global $wpdb;
	wp_enqueue_script('jquery-ui-datepicker');
	wp_enqueue_script('jquery.dataDatable', get_template_directory_uri() . '/js/jquery.dataTables.min.js', array('jquery'));
	wp_enqueue_style('jquery-ui-overcast', get_template_directory_uri() . '/js/css/overcast/jquery-ui-1.10.3.custom.css');

	// get the settings sections array
	$settings_output = contactstats_get_settings();

	$start_date =  strtotime($_GET['startDate']);
	if (empty($_GET['startDate']) ||  !$start_date) {
		//$start_date = date("d.m.Y", mktime(0, 0, 0, 1 , 1, date("Y")));
		$start_date = mktime(0, 0, 0, 1 , 1, date("Y"));
	}
	$end_date =  strtotime($_GET['enddDate']);
	if (empty($_GET['enddDate']) || !$end_date) {
		//$end_date = date("d.m.Y", mktime(0, 0, 0, 12 , 31, date("Y")));
		$end_date = mktime(0, 0, 0, 12 , 31, date("Y"));
	}
	showContactStatInlineJavascript();
	showContactStatInlineCSS();
	
	/**
	 * 	display form to filter data:
	 */
	?>
<div class="wrap">
	<div class="icon32" id="icon-options-general"></div>
	<h2>
		<?php echo "Statistiques d'utilisation des formulaires de contact"; ?>
	</h2>

	<form method="get">
		<input id="page" name="page" type="hidden"
			value="statistics_contact_form" /> <label for="startDate">Date de
			d&eacute;but :</label> <input id="startDate" name="startDate"
			onchange="submit()" value="<?php echo date("d.m.Y", $start_date); ?>" />
		<label for="enddDate">Date de fin :</label> <input id="enddDate"
			onchange="submit()" name="enddDate"
			value="<?php echo date("d.m.Y", $end_date); ?>" /> <br />
		<?php
		// if true, show 1 entry by line, otherwise group entries
		$showDetail = true;

		// preparation of SQL query:
		$query = "";
		$queryGroupBy = "";
		$queryWhere = "";
		
		// header names list:
		$columnnames = array();
		
		// content of thead 
		$tableHeader = "";

		// number of rows in result table:
		$rows = 0;

		// get and unserialize the form structure from db:
		$contactQuform = $wpdb->get_var($wpdb->prepare("SELECT config FROM " . $wpdb->prefix . "iphorm_forms WHERE id = 2;"));
		$form = maybe_unserialize($contactQuform);
		$elements = $form["elements"];
		$receiverEmail = $form["recipients"][0]; 

		// analyze contact form structure to prepare query:
		foreach($elements as $element) {
			if($element["type"] === 'select' && ($element["label"] == 'Discipline' 
												||  $element["label"] == 'Sujet' 
												||  $element["label"] == 'BCUL Riponne-Palais de Rumine' 
												||  $element["label"] == 'Dépôt')) {
				$included = false;
				if(empty($element["logic_rules"])) {
					// no logic rules : dropdown always visible
					$included = true;
				} else{
					$allValid = true;
					// don't show dropdown if one of the logic condition is not respected
					foreach($element["logic_rules"] as $rule) {
						if(($rule["operator"] === 'eq' && $rule["value"] !== str_replace("\\'", "'", $_GET["result_" .  $rule["element_id"]])) ||
								($rule["operator"] !== 'eq' && $rule["value"] === str_replace("\\'", "'", $_GET["result_" .  $rule["element_id"]]))){
							$allValid = false;
						}
					}
					if($allValid) {
						$included = true;
					}
				}
					
				if($included) {
					$rowname = "result_" .  $element["id"];
					$rownames[] = $rowname;
					if($query === "") {
						$query .= "SELECT ";
					} else {
						$query .= ",";
					}
					$query .= " (select value FROM " . $wpdb->prefix . "iphorm_form_entry_data where entry_id = e.id and element_id = " . $element["id"] . ") as result_" .  $element["id"] . " ";

					if(isset($_GET[$rowname]) && $_GET[$rowname] != "") {
						// add the values selected by the user to the where
						if($queryWhere === "") {
							$queryWhere .= " WHERE ";
						} else {
							$queryWhere .= " AND ";
						}
						$queryWhere .= $wpdb->prepare("result_" .  $element["id"] . " = '%s'", str_replace("\'", "&#039;", $_GET[$rowname]));
					} else {
						// at least 1 drowndown has no selected value: we must show grouped results
						$showDetail = false;
					}

					if($queryGroupBy === "") {
						$queryGroupBy .= " GROUP BY ";
					} else {
						$queryGroupBy .= ", ";
					}
					$queryGroupBy .= "result_" .  $element["id"] . " ";
					$elementIds[] = $element["id"];
					echo "<label>" . $element["label"] . " :</label>";
					echo "<select id=\"$rowname\" name=\"$rowname\" onchange=\"submit()\">";
					echo '<option value="">-</option>';
					foreach($element["options"] as $option) {
						if($option["value"] != "") {
							echo '<option value="' . $option["value"] . '"';
							if(isset($_GET[$rowname]) && str_replace("\\'", "'", $_GET[$rowname]) === $option["value"])  {
								echo ' selected="selected" ';
								// find possible conditional email recipient
								foreach($form[conditional_recipients] as $mailRecipient){
									if($mailRecipient['element'] ==  $element["id"] && 
											(($mailRecipient['operator'] == 'eq' && $mailRecipient['value'] == $option["value"]) ||
											($mailRecipient['operator'] != 'eq' && $mailRecipient['value'] != $option["value"]))) {
										$receiverEmail = $mailRecipient['recipient'];
									}
								}
							}
							echo '>'. $option["value"] . '</option>';
						}
					}
					echo "</select>";
					$tableHeader .= "<th>"  . $element["label"] . "</th>";
					$rows++;
				}
			} elseif($element["label"] === 'Nom'){
				$lastnameId =  $element["id"];
			} elseif($element["label"] === 'Prénom'){
				$firstnameId =  $element["id"];
			} elseif($element["label"] === 'Adresse e-mail'){
				$emailId =  $element["id"];
			}
		}
		echo "<br /> <br />";
		
		
		/**
		 * display data table:
		 */ 
		
		// prepare max and min date for query:
		$dateCondition = "AND date_added >= '" . date('Y-m-d', $start_date) . "' AND date_added < '" .  date('Y-m-d', strtotime('+1 days', $end_date)) . "'";
		if($showDetail){
			// all dropdown values selected by the user : execute query to display 1 message by line
			$statistics = $wpdb->get_results($wpdb->prepare("SELECT 1 as total, subquery.* FROM ($query, e.*, "
					. "(select value FROM " . $wpdb->prefix . "iphorm_form_entry_data where entry_id = e.id and element_id = " . $firstnameId . ") as firstname, "
					. "(select value FROM " . $wpdb->prefix . "iphorm_form_entry_data where entry_id = e.id and element_id = " . $lastnameId . ") as lastname, "
					. "(select value FROM " . $wpdb->prefix . "iphorm_form_entry_data where entry_id = e.id and element_id = " . $emailId . ") as email "
					. " FROM `" . $wpdb->prefix . "iphorm_form_entries` e WHERE form_id = 2 $dateCondition) as subquery $queryWhere ORDER BY date_added DESC"));
		} else {
			// some dropdown values not selected : execute query to display messages grouped by unselected dropwdown values
			$statistics = $wpdb->get_results($wpdb->prepare("SELECT count(*) as total, subquery.* FROM ($query FROM `" . $wpdb->prefix . "iphorm_form_entries` e WHERE form_id = 2 $dateCondition) as subquery $queryWhere $queryGroupBy"));
		}

		// count row total for footer:
		$total = 0;
		foreach ( $statistics as $result ) {
			$total += $result->total;
		} ?>
		<table id="resultTable" style="width: 100%">
			<thead>
				<?php
				// display header row:
				echo $tableHeader;
				if($showDetail){
					echo "<th>Date</th>";
					echo "<th>IP</th>";
					echo "<th>Nom</th>";
					echo "<th>Prénom</th>";
					echo "<th>Expéditeur</th>";
					echo "<th>Destinataire</th>";
		} ?>
				<th>Total</th>
			</thead>
			<tfoot>
				<tr>
					<td style="font-weight: bold;"
						colspan="<?php echo ($showDetail ? ($rows + 6) : $rows);?>">Total</td>
					<td style="text-align: right; font-weight: bold;"><?php echo $total; ?>
					</td>
				</tr>
			</tfoot>
			<tbody>
				<?php
				foreach ( $statistics as $result ) {
					echo "<tr>";
					foreach($rownames as $rowname) {
						echo '<td>' . $result->$rowname . '</td>';
					}
					if($showDetail){
						echo '<td>' . date("d.m.Y H:i", strtotime($result->date_added)) . '</td>';
						echo '<td>' . $result->ip . '</td>';
						echo '<td>' . $result->lastname . '</td>';
						echo '<td>' . $result->firstname . '</td>';
						echo '<td>' . $result->email . '</td>';
						echo '<td>' . $receiverEmail . '</td>';
					}
					echo '<td style="text-align: right; width: 60px;" >' . $result->total . '</td>';
					echo "</tr>";
				}
				?>
			</tbody>
		</table>
	</form>
</div>
<!-- wrap -->
<?php }  