<?php
/**
 * Template part for displaying single posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package CDI_WP_1.0.0
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <header class="entry-header">
        <?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
    </header><!-- .entry-header -->

    <footer class="entry-meta">
        <?php cdiwp_posted_on(); ?>

        <?php cdiwp_entry_footer(); ?>
    </footer><!-- .entry-meta -->

    <?php
    //$values = get_field_object( 'image_une_format' );
    //if( in_array( "oui", $values ) ): ?>

    <?php if( get_field( 'image_une_format' ) ): ?>

        <div class="entry-thumbnail-alt">
            <?php the_post_thumbnail() ?>
        </div><!-- .entry-thumbnail -->

        <?php the_content(); ?>

        <div class="entry-content clear">

    <?php else: ?>

        <div class="entry-thumbnail">
            <?php the_post_thumbnail() ?>
        </div><!-- .entry-thumbnail -->

        <div class="entry-content">
            <?php the_content(); ?>

    <?php endif; ?>

    <?php if ( function_exists( 'cdi_social' ) ) {
        cdi_social();
    } ?>

    <?php
        wp_link_pages( array(
            'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'cdiwp' ),
            'after'  => '</div>',
        ) );
    ?>
    </div><!-- .entry-content -->
</article><!-- #post-## -->
