<?php
/**
 * Template part for displaying results in search pages.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package CDI_WP_1.0.0
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="entry-content">
		<?php
		//$values = get_field_object( 'image_une_format' );
		//if( in_array( "oui", $values ) ): ?>

		<?php if( get_field( 'image_une_format' ) ): ?>	
			<div class="entry-thumbnail-alt">
				<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail() ?></a>
			</div><!-- .entry-thumbnail -->

			<header class="entry-header">
				<?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
			</header><!-- .entry-header -->

			<?php if ( 'post' === get_post_type() ) : ?>
			<footer class="entry-meta">
				<?php cdiwp_posted_on(); ?>

				<?php cdiwp_entry_footer(); ?>
			</footer><!-- .entry-meta -->
			<?php endif; ?>

		<?php else: ?>

			<header class="entry-header">
				<?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
			</header><!-- .entry-header -->

			<?php if ( 'post' === get_post_type() ) : ?>
			<footer class="entry-meta">
				<?php cdiwp_posted_on(); ?>

				<?php cdiwp_entry_footer(); ?>
			</footer><!-- .entry-meta -->
			<?php endif; ?>

			<div class="entry-thumbnail">
				<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail() ?></a>
			</div><!-- .entry-thumbnail -->

		<?php endif; ?>

		<?php the_excerpt(); ?>

		<a href="<?php the_permalink(); ?>"><?php echo esc_html__( 'More', 'cdiwp' ) ?></a>
		<?php
			// the_content( sprintf(
			// 	/* translators: %s: Name of current post. */
			// 	wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'cdiwp' ), array( 'span' => array( 'class' => array() ) ) ),
			// 	the_title( '<span class="screen-reader-text">"', '"</span>', false )
			// ) );
		?>

		<?php
			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'cdiwp' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->
</article><!-- #post-## -->

