<?php
/**
 * Template part for displaying page content in front-page.php.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package CDI_WP_1.0.0
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<div class="entry-content">
		<?php
		//$values = get_field_object( 'image_une_format' );
		//if( in_array( "oui", $values ) ): ?>

		<?php if( get_field( 'image_une_format' ) ): ?>

			<div class="entry-thumbnail-alt">
				<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail() ?></a>
			</div><!-- .entry-thumbnail-alt -->

			<a href="<?php the_permalink(); ?>"><h2><?php the_title(); ?></h2></a>

			<footer class="entry-meta">
				<?php cdiwp_posted_on(); ?>

				<?php cdiwp_entry_footer(); ?>
			</footer><!-- .entry-meta -->

		<?php else: ?>
		
			<a href="<?php the_permalink(); ?>"><h2><?php the_title(); ?></h2></a>

			<footer class="entry-meta">
				<?php cdiwp_posted_on(); ?>

				<?php cdiwp_entry_footer(); ?>
			</footer><!-- .entry-meta -->
		
			<div class="entry-thumbnail">
				<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail() ?></a>
			</div><!-- .entry-thumbnail -->

		<?php endif; ?>

		<div class="entry-content-justify">
			<?php the_excerpt(); ?>
		</div>

		<a href="<?php the_permalink(); ?>"><?php echo esc_html__( 'More', 'cdiwp' ) ?></a>

		<?php
			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'cdiwp' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer"></footer><!-- .entry-footer -->
</article><!-- #post-## -->

