<?php
/*
 * Template Name: Qui sommes-nous ?
 * Description: Modèle pour la page Qui sommes-nous ?
 */
get_header(); ?>
 
<?php get_sidebar( 'menu' ); ?>

	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">

			<h2><?php _e( 'Authors list', 'cdiwp' ); ?></h2>

			<?php
			// WP_User_Query arguments
			$args = array (
				'role'  => 'Editor',
			);

			// The User Query
			$user_query = new WP_User_Query( $args );

			if ( ! empty( $user_query->results ) ) {
			?>

			<ul>
				<?php foreach ( $user_query->results as $user ) { ?>
				<li><a href="<?php echo get_author_posts_url($user->ID); ?>"><?php echo $user->display_name ?></a></li>
				<?php } ?>				
			</ul>

			<?php
			}
			?>

			<?php while ( have_posts() ) : the_post(); ?>

				<?php get_template_part( 'template-parts/content', 'page' ); ?>

			<?php endwhile; // End of the loop. ?>

		</main><!-- #main -->
	</div><!-- #primary -->

<?php get_sidebar(); ?>
<?php get_footer(); ?>
