<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package CDI_WP_1.0.2
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<?php wp_head(); ?>
<!-- Favicons -->
<link rel="apple-touch-icon" sizes="57x57" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/apple-touch-icon-57x57.png?v=201603081054'; ?>">
<link rel="apple-touch-icon" sizes="60x60" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/apple-touch-icon-60x60.png?v=201603081054'; ?>">
<link rel="apple-touch-icon" sizes="72x72" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/apple-touch-icon-72x72.png?v=201603081054'; ?>">
<link rel="apple-touch-icon" sizes="76x76" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/apple-touch-icon-76x76.png?v=201603081054'; ?>">
<link rel="apple-touch-icon" sizes="114x114" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/apple-touch-icon-114x114.png?v=201603081054'; ?>">
<link rel="apple-touch-icon" sizes="120x120" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/apple-touch-icon-120x120.png?v=201603081054'; ?>">
<link rel="apple-touch-icon" sizes="144x144" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/apple-touch-icon-144x144.png?v=201603081054'; ?>">
<link rel="apple-touch-icon" sizes="152x152" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/apple-touch-icon-152x152.png?v=201603081054'; ?>">
<link rel="apple-touch-icon" sizes="180x180" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/apple-touch-icon-180x180.png?v=201603081054'; ?>">
<link rel="icon" type="image/png" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/favicon-32x32.png?v=201603081054'; ?>" sizes="32x32">
<link rel="icon" type="image/png" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/android-chrome-192x192.png?v=201603081054'; ?>" sizes="192x192">
<link rel="icon" type="image/png" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/favicon-96x96.png?v=201603081054'; ?>" sizes="96x96">
<link rel="icon" type="image/png" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/favicon-16x16.png?v=201603081054'; ?>" sizes="16x16">
<link rel="manifest" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/manifest.json'; ?>">
<link rel="mask-icon" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/safari-pinned-tab.svg?v=201603081054'; ?>" color="#9b0044">
<link rel="shortcut icon" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/favicon.ico?v=201603081054'; ?>">
<meta name="msapplication-TileColor" content="#9b0044">
<meta name="msapplication-TileImage" content="<?php echo get_stylesheet_directory_uri() . '/img/favicons/mstile-144x144.png?v=201603081054'; ?>">
<meta name="msapplication-config" content="<?php echo get_stylesheet_directory_uri() . '/img/favicons/browserconfig.xml'; ?>">
<meta name="theme-color" content="#ffffff">
<script>document.documentElement.className = document.documentElement.className.replace(/\bno-js\b/,'js');</script>
</head>

<body <?php body_class(); ?> role="document">
<div id="page" class="hfeed site">
	<header id="masthead" class="site-header" role="banner">
		<div class="site-branding">
			<?php if ( is_front_page() || is_home() ) : ?>
				<h1 class="site-title"><img src="<?php echo get_stylesheet_directory_uri() . '/img/bcul-le-blog.png'; ?>" width="1250" height="196" alt="<?php bloginfo( 'name' ); ?>" /></h1>
			<?php else : ?>
				<p class="site-title"><img src="<?php echo get_stylesheet_directory_uri() . '/img/bcul-le-blog.png'; ?>" width="1250" height="196" alt="<?php bloginfo( 'name' ); ?>" /></p>
			<?php endif; ?>
		</div><!-- .site-branding -->

		<a href="http://www.bcu-lausanne.ch" class="bcul-link"><img src="<?php echo get_stylesheet_directory_uri() . '/img/bcul.png'; ?>" width="170" height="100" alt="Site web de la BCUL" /></a>
	</header><!-- #masthead -->

	<?php if ( function_exists('ffeeeedd__ariane') && !is_front_page() ) {
		ffeeeedd__ariane();
	} ?>

	<div id="content" class="site-content">