<?php
/**
 * Fonction pour créer un widget Facebook
 *
 * @author 		Luc Poupard
 * @see 		http://www.guillaumevoisin.fr/tutoriels/tutoriel-wordpress-creer-un-widget
 * @note 		Dans le tuto précédent, remplacer "parent::WP_Widget" par "parent::__construct"
 *				http://themes-wordpress-francais.com/notice-wp_widget-solution/
 *
 * @package 	CDI_WP_Child_1.0.3
 * @since 		1.0.2
 */

class FacebookPage extends WP_Widget {
	// Constructeur
	function FacebookPage() {
		parent::__construct(
			false,
			$name = 'Page Facebook',
			array(
				"description" => 'Affichage d\'un bloc Page Facebook'
			)
		);
	}

	// Contenu du widget à afficher
	function widget( $args, $instance ) {
		// Extraction des paramètres du widget
		extract( $args );

		// Récupération de chaque paramètre
		$page_url = $instance['page_url'];
		$page_name = $instance['page_name'];

		// Voir le détail sur ces variables plus bas
		echo $before_widget;
		?>

		<div class="fb-widget">
			<div class="fb-page"
				data-href="<?php echo $page_url ?>"
				data-small-header="false"
				data-adapt-container-width="true"
				data-hide-cover="false"
				data-show-facepile="true">
				<div class="fb-xfbml-parse-ignore">
					<blockquote cite="<?php echo $page_url ?>">
						<a href="<?php echo $page_url ?>"><?php echo $page_name ?></a>
					</blockquote>
				</div>
			</div>
		</div>

		<?php
		echo $after_widget;
	}

	// Modification des paramètres du widget
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		// Récupération des paramètres envoyés
		$instance['page_url'] = $new_instance['page_url'];
		$instance['page_name'] = $new_instance['page_name'];

		return $instance;
	}

	// Affichage des paramètres du widget dans l'admin
	function form( $instance ) {
		$page_url = esc_attr( $instance['page_url'] );
		$page_name = esc_attr( $instance['page_name'] );
		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'page_url' ); ?>">
				<?php _e( 'URL de la page :', 'cdiwp' ); ?>
				<input class="widefat" id="<?php echo $this->get_field_id( 'page_url' ); ?>" name="<?php echo $this->get_field_name( 'page_url' ); ?>" type="text" value="<?php echo $page_url; ?>" />
			</label>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'page_name' ); ?>">
				<?php _e( 'Nom de la page :', 'cdiwp' ); ?>
				<input class="widefat" id="<?php echo $this->get_field_id( 'page_name' ); ?>" name="<?php echo $this->get_field_name( 'page_name' ); ?>" type="text" value="<?php echo $page_name; ?>" />
			</label>
		</p>

		<?php
	}
}
add_action( 'widgets_init', create_function( '', 'return register_widget("FacebookPage");' ) );