<?php
/**
 * Fonctions pour gérer les shortcodes du projet
 *
 * @author 		Luc Poupard
 * @see 		http://wp-themes-pro.com/shortcode-wordpress/
 *
 * @package 	CDI_WP_Child_1.0.2
 * @since 		1.0.2
 */


/* ----------------------------- */
/* Sommaire */
/* ----------------------------- */
/*
  == Nettoyage du code généré
  == Déclaration des shortcodes
*/


/* == @section Nettoyage du code généré ==================== */
/* On empêche l'insertion de <p> et <br> automatique dans les shortcodes
 * @see http://sww.co.nz/solution-to-wordpress-adding-br-and-p-tags-around-shortcodes/
 *
 * @note Pour que les balises <p> et <br /> soient gérées dans le shortcode,
 * ajoutez la ligne suivante dans la fonction du shortcode :
 * $content = wpautop( trim( $content ) );
 */
remove_filter( 'the_content', 'wpautop' );
add_filter( 'the_content', 'wpautop' , 99);


/* == @section Déclaration des shortcodes ==================== */

/* -- @subsection Shortcode simple -------------------- */
/* 
 * Exemple de code pour un shortcode 
 * [shortcode_simple]
 */
function cdiwpchild_shortcode_simple() {
	return '<code>Code à afficher par le shortcode</code>';
}
add_shortcode( 'shortcode_simple', 'cdiwpchild_shortcode_simple' );


/* -- @subsection Shortcode encapsulé -------------------- */
/* 
 * Exemple de code pour un shortcode encapsulé avec un paramètre
 * [shortcode_encapsule param="valeur"]contenu[/shortcode_encapsule]
 */
function cdiwpchild_shortcode_encapsule( $atts, $content = null ) {
	// Attributs
	extract( shortcode_atts(
		array(
			'param' => '', /* Ajoute un paramètre "class" */
		), $atts )
	);
	// Code
	return '<code class="' . $param . '">' . do_shortcode($content) . '</code>';
}
add_shortcode( 'shortcode_encapsule', 'cdiwpchild_shortcode_encapsule' );