<?php
/**
 * Fonctions du thème
 *
 * @author 		Luc Poupard
 *
 * @link 		https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package 	CDI_WP_Child_1.0.7
 * @since 		1.0.0
 */


/* ----------------------------- */
/* Sommaire */
/* ----------------------------- */
/*
  == Traductions du thème
  == Ajout des styles du thème
  == Fonctions externalisées
    -- Administration
*/


/* == @section Traductions du thème ==================== */
/*
 * Préparer le thème pour traduction.
 * Les traductions sont placées dans le répertoire /languages/
 * Pour traduire un terme : esc_html__( 'Terme à traduire', 'cdiwp' )
 */
function bculblog_setup() {
	load_theme_textdomain( 'cdiwp', get_stylesheet_directory() . '/languages' );

	/*
	 * On ajoute le support des Images à la une
	 */

	add_theme_support( 'post-thumbnails' );
	set_post_thumbnail_size( 400, 9999 ); // 9999 = illimité

	/*
	 * On gère la balise <title> dans WordPress et pas dans le thème.
	 */
	add_theme_support( 'title-tag' );

	add_theme_support( 'automatic-feed-links' );	

	/* 
	 * Déclaration du menu de navigation principal.
	 * Pour ajouter des menus supplémentaires, passer par le thème enfant.
	 */
	register_nav_menus( array(
		'primary' => esc_html__( 'Primary Menu', 'cdiwp' ),
	) );

	/*
	 * Remplacer les champs de formulaire natifs par des champs HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form',
		'comment-list',
		'gallery',
		'caption',
	) );
}
add_action( 'after_setup_theme', 'bculblog_setup' );


/* == @section Ajout des styles du thème ==================== */
function cdiwpchild_styles() {
	wp_register_style(
		'all',
		get_stylesheet_directory_uri() . '/css/styles.css',
		false,
		null,
		'all'
	);

	// On ajoute les fichiers à la queue
	wp_enqueue_style( 'all' );
}
add_action( 'wp_enqueue_scripts', 'cdiwpchild_styles' );


/**
 * @note On déclare une zone de widgets Sidebar par défaut.
 * Pour ajouter des zone de widgets supplémentaires, passer par le thème enfant.
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
// function cdiwp_widgets_init() {
// 	register_sidebar( array(
// 		'name'          => esc_html__( 'Sidebar', 'cdiwp' ),
// 		'id'            => 'sidebar-1',
// 		'description'   => '',
// 		'before_widget' => '<div class="widget">',
// 		'after_widget'  => '</div>',
// 		'before_title'  => '<div class="widget-title">',
// 		'after_title'   => '</div>',
// 	) );
// }
// add_action( 'widgets_init', 'cdiwp_widgets_init' );


function bcul_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Menu', 'cdiwp' ),
		'id'            => 'menu',
		'description'   => '',
		'before_widget' => '<div class="widget">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="widget-title">',
		'after_title'   => '</div>',
	) );
}
add_action( 'widgets_init', 'bcul_widgets_init' );


/* == @section Grand ménage dans <head> ==================== */
/**
 * @note On supprime la version de WordPress dans les URL CSS et JavaScript.
 * @link http://b-website.com/nettoyer-les-numeros-de-versions-dans-le-header-de-wordpress
*/
if ( ! function_exists( 'cdiwp_remove_wp_ver_css_js' ) ) :
function cdiwp_remove_wp_ver_css_js( $src ) {
	global $wp_version;
	parse_str( parse_url( $src, PHP_URL_QUERY ), $query );
	if ( ! empty( $query['ver'] ) && $query['ver'] === $wp_version ) {
		$src = remove_query_arg( 'ver', $src );
	}
	return $src;
}
endif; // cdiwp_setup
add_filter( 'style_loader_src', 'cdiwp_remove_wp_ver_css_js', 9999 ); // Version de WP dans les URL CSS	
add_filter( 'script_loader_src', 'cdiwp_remove_wp_ver_css_js', 9999 ); // Version de WP dans les URL JS



/* == @section Fonctions externalisées ==================== */
/**
 * Fonctions pour personnaliser l'administration.
 * @note Pour ne pas utiliser une fonction, il suffit de commenter la ligne correspondante.
 */

/* Nettoyage balise <head>
 * Nettoyage effectué par défaut dans le thème parrent
 * Utiliser cette fonction uniquement pour personnaliser davantage
 * Par exemple pour nettoyer le code d'une extension
 */
require get_stylesheet_directory() . '/functions/head-cleaning.php';

/* Anti-spam */
require get_stylesheet_directory() . '/functions/global_antispam.php';

/* Shortcodes */
// require get_stylesheet_directory() . '/functions/shortcodes.php';

require get_stylesheet_directory() . '/functions/template-tags.php';

/* Widgets */
// require get_stylesheet_directory() . '/functions/widget_facebook.php';
// require get_stylesheet_directory() . '/functions/widget_newsletter-cdi.php';

/* -- @subsection Administration -------------------- */
/*
 * @note
 * Ces fonctions sont déclarées par défaut dans le thème parent.
 * Décommenter et personnaliser ces fichiers pour modifier les paramètres appliquées par défaut.
 */
if ( is_admin() ) {
	/* Notification de mises à jour du thème */
	require get_stylesheet_directory() . '/functions/admin_update-notifier.php';
	
	/* Cacher les mises à jour aux non administrateurs */
	require get_stylesheet_directory() . '/functions/admin_update-notifications.php';

	/* Cacher les widgets du dashboard */
	require get_stylesheet_directory() . '/functions/admin_dashboard-widgets.php';

	/* Cacher des items du menu aux non administrateurs */
	require get_stylesheet_directory() . '/functions/admin_menu.php';
}

/* Personnaliser la barre d'administration */
/* On sort l'appel de la condition is_admin car la barre s'affiche aussi en dehors de l'admin */
require get_stylesheet_directory() . '/functions/admin_admin-bar.php';