<?php
/**
 * The template for displaying archive pages.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package CDI_WP_1.0.0
 */

get_header(); ?>
 
<?php get_sidebar( 'menu' ); ?>

	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">

		<?php if ( have_posts() ) : ?>

			<header class="page-header">
				<h1><?php _e( 'Author', 'cdiwp' ); ?> : <?php echo get_the_author_meta( 'display_name' ); ?></h1>
			</header><!-- .page-header -->

			<article itemscope itemtype="http://schema.org/Person">
				<?php if ( get_the_author_meta( 'description' ) ) { ?>
				<p itemprop="description"><?php the_author_meta( 'description' ); ?></p>
				<?php } ?>
			</article>

			<?php /* Start the Loop */ ?>
			<ul>
			<?php while ( have_posts() ) : the_post(); ?>
				<?php

					/*
					 * Include the Post-Format-specific template for the content.
					 * If you want to override this in a child theme, then include a file
					 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
					 */
					// get_template_part( 'template-parts/content', get_post_format() );
				?>				
				<?php the_title( sprintf( '<li><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></li>' ); ?>
			<?php endwhile; ?>
			</ul>

			<?php the_posts_navigation(); ?>

		<?php else : ?>

			<?php
			$current_author =  get_query_var('author');

			if( $current_author ) { ?>

				<h1><?php _e( 'Author', 'cdiwp' ); ?> : <?php echo get_the_author_meta( 'display_name', $current_author ); ?></h1>

				<article itemscope itemtype="http://schema.org/Person">
					<?php if ( get_the_author_meta( 'description', $current_author ) ) { ?>
					<p itemprop="description"><?php the_author_meta( 'description', $current_author ); ?></p>
					<?php } ?>
				</article>
				
			<?php } ?>
		
			<p>Cet auteur n'a pas encore écrit de billet.</p>

		<?php endif; ?>

		</main><!-- #main -->
	</div><!-- #primary -->

<?php get_sidebar(); ?>
<?php get_footer(); ?>
