function include(file) {
  var script  = document.createElement('script');
  script.src  = file;
  script.type = 'text/javascript';
  script.defer = true;
  document.getElementsByTagName('head').item(0).appendChild(script);
}

function setCookie(nom, valeur, expire, chemin, domaine, securite){
document.cookie = nom + ' = ' + escape(valeur) + '  ' +
  ((expire == undefined) ? '' : ('; expires = ' + expire.toGMTString())) +
  ((chemin == undefined) ? '' : ('; path = ' + chemin)) +
  ((domaine == undefined) ? '' : ('; domain = ' + domaine)) +
  ((securite == true) ? '; secure' : '');
}

var dtExpire = new Date();
dtExpire.setTime(dtExpire.getTime() + 3600 * 1000 * 24 * 365 );

function getCookie(name){
  if(document.cookie.length == 0)
    return null;

  var regSepCookie = new RegExp('(; )', 'g');
  var cookies = document.cookie.split(regSepCookie);

  for(var i = 0; i < cookies.length; i++){
    var regInfo = new RegExp('=', 'g');
    var infos = cookies[i].split(regInfo);
    if(infos[0] == name){
      return unescape(infos[1]);
    }
  }
  return null;
}

window.addEventListener('load', function(){
    var cookieValue = getCookie('denyCookies');

    var buttonAccept = document.getElementById( 'cookie-accept' );
    var buttonDeny = document.getElementById( 'cookie-deny' );
    var bodyCookie = document.getElementById( 'cookie-banner' );

    if( cookieValue == null ) {
        bodyCookie.classList.remove( 'cookie-banner-hidden' );
    } else {
        // do nothing
    }

    buttonAccept.onclick = function() {
      setCookie( 'denyCookies', 'accept', dtExpire, '/' );
      bodyCookie.classList.add( 'cookie-banner-clicked' );
    }
    buttonDeny.onclick= function() {
      setCookie( 'denyCookies', 'deny', dtExpire, '/' );
      bodyCookie.classList.add( 'cookie-banner-clicked' );
    }
});
