<?php
/**
 * Notification de mises à jour du thème
 *
 * @author	Luc Poupard
 *
 * Basé sur le code de Xpark Media
 * @link	https://xparkmedia.com/blog/add-update-notification-selfhosted-premium-themes-plugins/
 *
 * @package	Argotlab
 * @since	Argotlab 1.0.0
 */


function argotlab_update_notifier ( $transient ) {
	if( empty( $transient->checked['argotlab'] ) )
	return $transient;

	$ch = curl_init();

	curl_setopt( $ch, CURLOPT_URL, 'http://wp.cdi.ch/themes/argotlab/update.json' );

	/* Timeout de 3 secondes pour éviter les erreurs serveur */
	curl_setopt( $ch, CURLOPT_TIMEOUT, 3 ); 
	curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );

	$result = curl_exec( $ch );
	curl_close( $ch );

	/* On s'assure d'avoir reçu des données dans la réponse */
	if( empty( $result ) )
	return $transient;

	/* On vérifie la version sur le serveur par rapport à la version installée */
	if( $data = json_decode( $result ) ){
		if( version_compare( $transient->checked['argotlab'], $data->new_version, '<' ) )
		$transient->response['argotlab'] = (array) $data;
	}

	return $transient;
} 
add_filter ( 'pre_set_site_transient_update_themes', 'argotlab_update_notifier' );