<?php
/*
* Add your own functions here. You can also copy some of the theme functions into this file. 
* Wordpress will use those functions instead of the original functions then.
*/


/* ----------------------------- */
/* Sommaire */
/* ----------------------------- */
/*
  == Ajout des styles du thème parent
  == Ajout des styles et scripts du thème
  == Notifications de mise à jour
*/


/* == @section Ajout des styles du thème parent ==================== */
function enqueue_parent_styles() {
    wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
}
add_action( 'wp_enqueue_scripts', 'enqueue_parent_styles' );


/* == @section Ajout des styles et scripts du thème ==================== */
function argotlab_styles() {
    wp_register_style(
        'all',
        get_stylesheet_directory_uri().'/style.css',
        false,
        null,
        'all'
    );

    wp_register_script(
        'cookie-banner',
        get_stylesheet_directory_uri() . '/js/scripts.js',
        false,
        null,
        true
    );

    // On ajoute les fichiers à la queue
    wp_enqueue_style( 'all' );
    wp_enqueue_script( 'cookie-banner' );
}
add_action( 'wp_enqueue_scripts', 'argotlab_styles' );


/* == @section Notifications de mise à jour ==================== */
if ( is_admin() ) {
	/* Notification de mises à jour du thème */
	require get_stylesheet_directory() . '/functions/admin_update-notifier.php';
}