<?php
/*
Plugin Name: CDI Table of Content
Version: 1.0.0
Plugin URI: http://www.cdi.ch
Description: Sommaire
Author: CDI
Author URI: http://www.cdi.ch
Text Domain: cdi-toc
*/

if ( !defined( 'ABSPATH' ) ) die();

/* ----------------------------- */
/* Sommaire */
/* ----------------------------- */
/*
	== Crédits
	== Chargement des fichiers de traduction
	== Création du patron
	== Ajout d’un filtre sur le contenu
	== Création du sommaire
	== Création d’un shortcode pour afficher le sommaire
	== Permet l'utilisation de shortcodes dans les sidebars
	== Notifications de mise à jour
*/


/* == @section Crédits ==================== */
/**
 * @author Gaël Poupard
 * @see http://www.ffoodd.fr
 *
 * Plugin original : ffeeeedd__sommaire
 * @see https://github.com/ffoodd/ffeeeedd--extensions/tree/master/plugins/ffeeeedd__sommaire
 * @note Ajout et gestion d’un shortcode pour créer un sommaire.
 * @version 0.1
 */


/* == @section Chargement des fichiers de traduction ==================== */
function cdi_toc_init() {
	load_plugin_textdomain( 'cdi-toc', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
}
add_action( 'plugins_loaded', 'cdi_toc_init' );


/* == @section Création du patron ==================== */
/**
 * @author Willy Bahuaud
 * @see https://twitter.com/willybahuaud
 * @see http://wabeo.fr/blog/sommaire-article-wordpress/
 * @note Légèrement modifiée afin d’inclure des URLs absolues ainsi qu’un lien de retour en haut de page.
 */
function cdi_toc_patron( $matches ) {
	global $post;

	return '<h' . $matches[1] . $matches[2] . ' id="' .sanitize_title( $matches[3] ) . '">' . $matches[3] . ' <a href="' . get_permalink( $post->ID ) . '#toc" class="toc-back" title="' . __( 'Back to the table of content', 'cdi-toc' ) . '"><span class="visually-hidden">' . __( 'Back to the table of content', 'cdi-toc' ) . '</span></a></h' . $matches[4] . '>';
}


/* == @section Ajout d’un filtre sur le contenu ==================== */
function cdi_toc_ancres( $content ) {
	if ( is_singular( array( 'post', 'page' ) ) ) {
		global $post;

		/* On filtre tous les titres de niveau 2 */
		$pattern = "/<h([2])(.*?)>(.*?)<\/h([2])>/i";
		$content = preg_replace_callback( $pattern, 'cdi_toc_patron', $content );

		return $content;
	} else {
		return $content;
	}
}
add_filter( 'the_content', 'cdi_toc_ancres', 12 );


/* == @section Création du sommaire ==================== */
function cdi_toc( $echo = false ) {
	global $post;

	$obj = '<ol id="toc">';
	$original_content = $post->post_content;
	
	/* On récupère les titres */
	$patt = "/<h2(.*?)>(.*?)<\/h2>/i";
	preg_match_all( $patt, $original_content, $results );
	
	/* On génère les liens */
	foreach ( $results[2] as $k=>$r ) {
		$obj .= '<li><a href="' . get_permalink( $post->ID ) . '#' . sanitize_title( $r ) . '">' . $r . '</a></li>';
	}

	/* Si les commentaires sont ouverts et qu'il y en a, on rajoute un lien vers la zone de commentaire */
	if ( comments_open() && have_comments() ) {	
		$obj .= '<li><a href="' . get_permalink( $post->ID ) . '#comments">' . __( 'Comments', 'cdi-toc' ) . '</a></li></ol>';
	}

	if ( $echo ) {
		echo $obj;
	} else {
		return $obj;
	}
}


/* == @section Création d’un shortcode pour afficher le sommaire ==================== */
add_shortcode( 'sommaire', 'cdi_toc' );


/* == @section Permet l'utilisation de shortcodes dans les sidebars ==================== */
add_filter( 'widget_text', 'do_shortcode' );


/* == @section Notifications de mise à jour ==================== */
/**
 * On met en place une vérification des mises à jour de l'extension
 * @see http://w-shadow.com/blog/2010/09/02/automatic-updates-for-any-plugin/
 */
require 'update/plugin-update-checker.php';

$myUpdateChecker = PucFactory::buildUpdateChecker(
	'http://wp.cdi.ch/plugins/cdi-toc/update.json',
	__FILE__,
	'cdi-toc'
);