<?php
/*
Plugin Name: CDI Social
Version: 2.2.0
Plugin URI: http://www.cdi.ch
Description: Partage social
Author: CDI
Author URI: http://www.cdi.ch
Text Domain: cdi-social
*/

if ( !defined( 'ABSPATH' ) ) die();

/* ----------------------------- */
/* Sommaire */
/* ----------------------------- */
/*
    == Crédits
    == Chargement des fichiers de traduction
    == Création de la fonction
    == Création d’un shortcode pour afficher le sommaire
    == Permet l'utilisation de shortcodes dans les sidebars
    == Notifications de mise à jour
*/


/* == @section Crédits ==================== */
/**
 * @author Gaël Poupard
 * @see http://www.ffoodd.fr
 *
 * Plugin original : ffeeeedd__partage
 * @see https://github.com/ffoodd/ffeeeedd--extensions/tree/master/plugins/ffeeeedd__partage
 * @note Ajout et gestion d’une fonction de partage sur les réseaux sociaux.
 * @version 0.1
 */


/* == @section Chargement des fichiers de traduction ==================== */
function cdi_social_init() {
    load_plugin_textdomain( 'cdi-social', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
}
add_action( 'plugins_loaded', 'cdi_social_init' );


/* == @section Création de la fonction ====================
 * @note Si vous voulez ajouter d’autres réseaux sociaux :
 * @see http://www.crea-fr.com/blog/15-liens-de-partage-pour-les-reseaux-sociaux/
 */
function cdi_social() {
    global $post;
    if ( is_singular( 'post' ) ) {
        $link = esc_url( get_permalink() );

        return '
        <ul class="social-sharing">
            <li>
                <a href="https://twitter.com/intent/tweet?text=' . $link . '"
                target="_blank"
                title="' . __( 'New window', 'cdi-social' ) . '"
                rel="nofollow">' . __( 'Share on', 'cdi-social' ) . ' Twitter</a>
            </li>
            <li>
                <a href="https://www.facebook.com/sharer.php?u=' . $link . '&t=' . esc_attr( $post->post_title ) . '"
                target="_blank"
                title="' . __( 'New window', 'cdi-social' ) . '"
                rel="nofollow">' . __( 'Share on', 'cdi-social' ) . ' Facebook</a>
            </li>
            <li>
                <a href="mailto:?subject=' . esc_attr( $post->post_title ) . '?body=' . $link . '"
                rel="nofollow">' . __( 'Email to a friend', 'cdi-social' ) . '</a>
            </li>
            <li>
                <a href="javascript:window.print()"
                target="_blank"
                rel="nofollow">' . __( 'Print this post', 'cdi-social' ) . '</a>
                <strong>' . __( 'In order to print this post, please use the following keyboard shortcut: <kbd>Ctrl + P</kbd>', 'cdi-social' ) . '</strong>
            </li>
        </ul>';
    }
}


/* == @section Création d’un shortcode pour afficher le sommaire ==================== */
add_shortcode( 'cdi-social', 'cdi_social' );


/* == @section Permet l'utilisation de shortcodes dans les sidebars ==================== */
add_filter( 'widget_text', 'do_shortcode' );


/* == @section Notifications de mise à jour ==================== */
/**
 * On met en place une vérification des mises à jour de l'extension
 * @see http://w-shadow.com/blog/2010/09/02/automatic-updates-for-any-plugin/
 */
require 'update/plugin-update-checker.php';

$myUpdateChecker = PucFactory::buildUpdateChecker(
    'http://wp.cdi.ch/plugins/cdi-social/update.json',
    __FILE__,
    'cdi-social'
);
