<?php
/*
Plugin Name: CDI Responsive Menu
Version: 2.0.1
Plugin URI: http://www.cdi.ch
Description: Menu responsive
Author: CDI
Author URI: http://www.cdi.ch
*/

/* ----------------------------- */
/* Sommaire */
/* ----------------------------- */
/*
	== Injections JavaScript
	== Ajout de la classe .sf-menu
	== Notifications de mise à jour
*/


/* == @section Injections JavaScript ==================== */
/**
 * 
 * @see https://premium.wpmudev.org/blog/adding-scripts-and-styles-wordpress-enqueueing/
 */
function cdi_responsive_menu() {
	wp_enqueue_script(
		'superfish',
		plugins_url( 'js/superfish.1.7.9.min.js', __FILE__ ),
		array( 'jquery' ), // Dépendant de jQuery
		null, // Version
		true // true = script dans le footer
	);

	wp_enqueue_script(
		'mmenu',
		plugins_url( 'js/jquery.mmenu.5.7.8.all.min.js', __FILE__ ),
		array( 'jquery' ), // Dépendant de jQuery
		null, // Version
		true // true = script dans le footer
	);

	wp_enqueue_script(
		'mmenu-wp',
		plugins_url( 'js/jquery.mmenu.wordpress.js', __FILE__ ),
		array( 'mmenu' ), // Dépendant de mmenu
		null, // Version
		true // true = script dans le footer
	);

	wp_enqueue_script(
		'init',
		get_stylesheet_directory_uri() . '/js/init.menu.js', // Doit être placé dans le dossier js du thème enfant
		array( 'jquery', 'superfish', 'mmenu' ), // Dépendant de jQuery, superfish, mmenu
		null, // Version
		true // true = script dans le footer
	);
}
add_action( 'wp_enqueue_scripts', 'cdi_responsive_menu' );


/* == @section Ajout de la classe .sf-menu ==================== */
/**
 * On ajoute la classe pour Superfish au menu principal
 * @see https://developer.wordpress.org/reference/functions/wp_nav_menu/
 */
function responsive_menu_class( $args ) {
	if( 'primary' == $args['theme_location'] ) {
		$args['menu_class'] .= ' sf-menu';
	}
	return $args;
}
add_filter( 'wp_nav_menu_args', 'responsive_menu_class' );


/* == @section Notifications de mise à jour ==================== */
/**
 * On met en place une vérification des mises à jour de l'extension
 * @see http://w-shadow.com/blog/2010/09/02/automatic-updates-for-any-plugin/
 */
require 'update/plugin-update-checker.php';

$myUpdateChecker = PucFactory::buildUpdateChecker(
	'http://wp.cdi.ch/plugins/cdi-responsive-menu/update.json',
	__FILE__,
	'cdi-responsive-menu'
);