<?php
/*
Plugin Name: CDI Carrousel
Version: 1.0.0
Plugin URI: http://wp.cdi.ch/plugins/cdi-carrousel
Description: Carrousel responsive
Author: CDI
Author URI: https://www.cdi.ch
*/

/* ----------------------------- */
/* Sommaire */
/* ----------------------------- */
/*
	== Injections JavaScript
	== Notifications de mise à jour
*/


/* == @section Injections JavaScript ==================== */
/**
 * 
 * @see https://premium.wpmudev.org/blog/adding-scripts-and-styles-wordpress-enqueueing/
 */
function cdi_carrousel() {
	wp_enqueue_script(
		'superfish',
		plugins_url( 'js/jquery-accessible-carrousel-aria.js', __FILE__ ),
		array( 'jquery' ), // Dépendant de jQuery
		null, // Version
		true // true = script dans le footer
	);
}
add_action( 'wp_enqueue_scripts', 'cdi_carrousel' );


/* == @section Notifications de mise à jour ==================== */
/**
 * On met en place une vérification des mises à jour de l'extension
 * @see http://w-shadow.com/blog/2010/09/02/automatic-updates-for-any-plugin/
 */
require 'update/plugin-update-checker.php';

$myUpdateChecker = PucFactory::buildUpdateChecker(
	'http://wp.cdi.ch/plugins/cdi-carrousel/update.json',
	__FILE__,
	'cdi-carrousel'
);